import bcrypt from "bcryptjs";
import { db } from "./config/db.js";
import dotenv from "dotenv";

dotenv.config();

const name = "Admin";
const email = "admin@gmail.com";
const password = "open 123";

const createUserTable = () => {
  const sql = `
    CREATE TABLE IF NOT EXISTS users (
      id INT AUTO_INCREMENT PRIMARY KEY,
      name VARCHAR(100) NOT NULL,
      email VARCHAR(100) UNIQUE NOT NULL,
      password VARCHAR(255) NOT NULL,
      role ENUM('admin','user','superadmin') DEFAULT 'admin',
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )
  `;
  db.query(sql, (err) => {
    if (err) throw err;
    console.log("✅ Users table ready");
    createSuperAdmin();
  });
};

const createSuperAdmin = async () => {
  try {
    const hashed = await bcrypt.hash(password, 10);

    db.query("SELECT * FROM users WHERE email = ?", [email], (err, result) => {
      if (err) throw err;

      if (result.length > 0) {
        console.log("⚠️ Superadmin already exists!");
        process.exit();
      }

      const sql =
        "INSERT INTO users (name, email, password, role) VALUES (?, ?, ?, 'superadmin')";
      db.query(sql, [name, email, hashed], (err) => {
        if (err) throw err;
        console.log("✅ Superadmin created successfully!");
        process.exit();
      });
    });
  } catch (error) {
    console.error("❌ Error creating superadmin:", error);
    process.exit(1);
  }
};

createUserTable();
